// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDevtoolsClientInspectorMetrics_h
#define mozilla_GleanDevtoolsClientInspectorMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace devtools_grid_gridinspector {
  /**
   * generated from devtools.grid.gridinspector.opened
   * Number of times the DevTools grid inspector was opened from the grid view. This metric was generated to correspond to the Legacy Telemetry scalar devtools.grid.gridinspector.opened.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> opened(1153);
}

namespace devtools_inspector {
  /**
   * generated from devtools.inspector.fonteditor_font_type_displayed
   */
  enum class FonteditorFontTypeDisplayedLabel: uint16_t {
    eVariable = 0,
    eNonvariable = 1,
    e__Other__,
  };
  /**
   * Indicates if the font editor displayed its UI for a non-variable font or a variable font
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram DEVTOOLS_FONTEDITOR_FONT_TYPE_DISPLAYED.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, FonteditorFontTypeDisplayedLabel> fonteditor_font_type_displayed(1154);

  /**
   * generated from devtools.inspector.new_root_to_reload_delay
   * Time taken (in ms) to update the inspector during a page reload, starting from new-root event.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram DEVTOOLS_INSPECTOR_NEW_ROOT_TO_RELOAD_DELAY_MS.
   */
  constexpr impl::TimingDistributionMetric new_root_to_reload_delay(1155);

  /**
   * generated from devtools.inspector.node_selection_count
   * Number of times a different node is marked as selected in the Inspector regardless of the cause: context menu, manual selection in markup view, etc. This metric was generated to correspond to the Legacy Telemetry scalar devtools.inspector.node_selection_count.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> node_selection_count(1156);

  /**
   * generated from devtools.inspector.number_of_css_grids_in_a_page
   * On page load, record the number of CSS Grid elements present on a page when the DevTools is open
   * This metric was generated to correspond to the Legacy Telemetry linear histogram DEVTOOLS_NUMBER_OF_CSS_GRIDS_IN_A_PAGE.
   */
  constexpr impl::CustomDistributionMetric number_of_css_grids_in_a_page(1157);

  /**
   * generated from devtools.inspector.three_pane_enabled
   * Number of times the DevTools inspector was opened with the 3 pane inspector enabled, keyed by true/false. This metric was generated to correspond to the Legacy Telemetry scalar devtools.inspector.three_pane_enabled.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> three_pane_enabled(1158);
}

namespace devtools_layout_flexboxhighlighter {
  /**
   * generated from devtools.layout.flexboxhighlighter.opened
   * Number of times the DevTools flexbox highlighter was activated from the layout view. This metric was generated to correspond to the Legacy Telemetry scalar devtools.layout.flexboxhighlighter.opened.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> opened(1159);
}

namespace devtools_markup_flexboxhighlighter {
  /**
   * generated from devtools.markup.flexboxhighlighter.opened
   * Number of times the DevTools flexbox highlighter was activated from the markup view. This metric was generated to correspond to the Legacy Telemetry scalar devtools.markup.flexboxhighlighter.opened.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> opened(1160);
}

namespace devtools_markup_gridinspector {
  /**
   * generated from devtools.markup.gridinspector.opened
   * Number of times the DevTools grid inspector was opened from the markup view. This metric was generated to correspond to the Legacy Telemetry scalar devtools.markup.gridinspector.opened.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> opened(1161);
}

namespace devtools_markup_scrollable_badge {
  /**
   * generated from devtools.markup.scrollable.badge.clicked
   * Number of times the scrollable inspector badge has been clicked. This metric was generated to correspond to the Legacy Telemetry scalar devtools.markup.scrollable.badge.clicked.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> clicked(1162);
}

namespace devtools_rules_flexboxhighlighter {
  /**
   * generated from devtools.rules.flexboxhighlighter.opened
   * Number of times the DevTools flexbox highlighter was activated from the rules view. This metric was generated to correspond to the Legacy Telemetry scalar devtools.rules.flexboxhighlighter.opened.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> opened(1163);
}

namespace devtools_rules_gridinspector {
  /**
   * generated from devtools.rules.gridinspector.opened
   * Number of times the DevTools grid inspector was opened from the rules view. This metric was generated to correspond to the Legacy Telemetry scalar devtools.rules.gridinspector.opened.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> opened(1164);
}

namespace devtools_shadowdom {
  /**
   * generated from devtools.shadowdom.reveal_link_clicked
   * Whether the user clicked on any "reveal" link. "reveal" links are displayed in shadow dom trees in the markup view. This metric was generated to correspond to the Legacy Telemetry scalar devtools.shadowdom.reveal_link_clicked.
   */
  constexpr impl::BooleanMetric reveal_link_clicked(1165);

  /**
   * generated from devtools.shadowdom.shadow_root_displayed
   * Whether the markup view displayed any #shadow-root element in the UI. This metric was generated to correspond to the Legacy Telemetry scalar devtools.shadowdom.shadow_root_displayed.
   */
  constexpr impl::BooleanMetric shadow_root_displayed(1166);

  /**
   * generated from devtools.shadowdom.shadow_root_expanded
   * Whether the user expanded any #shadow-root element. This metric was generated to correspond to the Legacy Telemetry scalar devtools.shadowdom.shadow_root_expanded.
   */
  constexpr impl::BooleanMetric shadow_root_expanded(1167);
}

namespace devtools_tooltip {
  /**
   * generated from devtools.tooltip.shown
   * Number of times a tooltip was shown, keyed by tooltip type. Currently supported types are "image", "font-family", "inactive- css", "css-compatibility", "css-query-container" and "variable." This metric was generated to correspond to the Legacy Telemetry scalar devtools.tooltip.shown.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> shown(1168);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDevtoolsClientInspectorMetrics_h
