// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanGeckoTraceGeneratedMetrics_h
#define mozilla_GleanGeckoTraceGeneratedMetrics_h

#include "mozilla/JSONStringWriteFuncs.h"
#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace gecko_trace {
  /**
   * generated from gecko_trace.traces_data
   */

  struct TracesDataObjectResourceSpansItemResourceAttributes {
    Maybe<int64_t> gecko.process.internal_id;
    Maybe<nsCString> gecko.process.type;
    Maybe<nsCString> service.name;
    Maybe<nsCString> telemetry.sdk.language;
    Maybe<nsCString> telemetry.sdk.name;
    Maybe<nsCString> telemetry.sdk.version;
  };


  struct TracesDataObjectResourceSpansItemResource {
    Maybe<TracesDataObjectResourceSpansItemResourceAttributes> attributes;
  };


  struct TracesDataObjectResourceSpansItemScopeSpansItemScope {
    Maybe<nsCString> name;
  };


  struct TracesDataObjectResourceSpansItemScopeSpansItemSpansItemEventsItemAttributes {
    Maybe<nsCString> source.file;
    Maybe<int64_t> source.line;
    Maybe<nsCString> frame_id;
    Maybe<nsCString> result;
    Maybe<nsCString> severity;
  };


  struct TracesDataObjectResourceSpansItemScopeSpansItemSpansItemEventsItem {
    Maybe<nsCString> name;
    Maybe<int64_t> time_unix_nano;
    Maybe<TracesDataObjectResourceSpansItemScopeSpansItemSpansItemEventsItemAttributes> attributes;
  };

  using TracesDataObjectResourceSpansItemScopeSpansItemSpansItemEvents = nsTArray<TracesDataObjectResourceSpansItemScopeSpansItemSpansItemEventsItem>;


  struct TracesDataObjectResourceSpansItemScopeSpansItemSpansItem {
    Maybe<nsCString> trace_id;
    Maybe<nsCString> span_id;
    Maybe<nsCString> parent_span_id;
    Maybe<nsCString> name;
    Maybe<int64_t> start_time_unix_nano;
    Maybe<int64_t> end_time_unix_nano;
    Maybe<TracesDataObjectResourceSpansItemScopeSpansItemSpansItemEvents> events;
  };

  using TracesDataObjectResourceSpansItemScopeSpansItemSpans = nsTArray<TracesDataObjectResourceSpansItemScopeSpansItemSpansItem>;


  struct TracesDataObjectResourceSpansItemScopeSpansItem {
    Maybe<TracesDataObjectResourceSpansItemScopeSpansItemScope> scope;
    Maybe<TracesDataObjectResourceSpansItemScopeSpansItemSpans> spans;
  };

  using TracesDataObjectResourceSpansItemScopeSpans = nsTArray<TracesDataObjectResourceSpansItemScopeSpansItem>;


  struct TracesDataObjectResourceSpansItem {
    Maybe<TracesDataObjectResourceSpansItemResource> resource;
    Maybe<TracesDataObjectResourceSpansItemScopeSpans> scope_spans;
  };

  using TracesDataObjectResourceSpans = nsTArray<TracesDataObjectResourceSpansItem>;


  struct TracesDataObject {
    Maybe<nsCString> version;
    Maybe<TracesDataObjectResourceSpans> resource_spans;
  };
  /**
   * Represents the telemetry traces data collected during browser operation. This data provides insights into errors that occur in Firefox during runtime.
   * Based on the [TracesData OTLP](1) protobuf definition which provides a standardized format for collecting and transmitting trace information.
   * [1]: https://github.com/open-telemetry/opentelemetry-proto/blob/c0a98a1847d3124ac5f9ecd02d0e2d2732bbb590/opentelemetry/proto/trace/v1/trace.proto#L38
   */
  constexpr impl::ObjectMetric<TracesDataObject, struct TracesDataObjectTag> traces_data(4898);
}

template <>
inline void impl::ObjectMetric<gecko_trace::TracesDataObject, gecko_trace::TracesDataObjectTag>::Set(const gecko_trace::TracesDataObject& aObj) const {
  nsCString json;
  JSONStringRefWriteFunc writeFunc(json);
  JSONWriter writer(writeFunc, JSONWriter::CollectionStyle::SingleLineStyle);

  writer.StartObjectElement();
  {
    if (aObj.version.isSome()) {
      writer.StringProperty("version", *(aObj.version));
    }
    if (aObj.resource_spans.isSome()) {
      writer.StartArrayProperty("resource_spans");
      for (const auto& aobjResourceSpansItem: *aObj.resource_spans) {
        writer.StartObjectElement();
        {
          if (aobjResourceSpansItem.resource.isSome()) {
            writer.StartObjectProperty("resource");
            if (aobjResourceSpansItem.resource->attributes.isSome()) {
              writer.StartObjectProperty("attributes");
              if (aobjResourceSpansItem.resource->attributes->gecko.process.internal_id.isSome()) {
                writer.IntProperty("gecko.process.internal_id", *(aobjResourceSpansItem.resource->attributes->gecko.process.internal_id));
              }
              if (aobjResourceSpansItem.resource->attributes->gecko.process.type.isSome()) {
                writer.StringProperty("gecko.process.type", *(aobjResourceSpansItem.resource->attributes->gecko.process.type));
              }
              if (aobjResourceSpansItem.resource->attributes->service.name.isSome()) {
                writer.StringProperty("service.name", *(aobjResourceSpansItem.resource->attributes->service.name));
              }
              if (aobjResourceSpansItem.resource->attributes->telemetry.sdk.language.isSome()) {
                writer.StringProperty("telemetry.sdk.language", *(aobjResourceSpansItem.resource->attributes->telemetry.sdk.language));
              }
              if (aobjResourceSpansItem.resource->attributes->telemetry.sdk.name.isSome()) {
                writer.StringProperty("telemetry.sdk.name", *(aobjResourceSpansItem.resource->attributes->telemetry.sdk.name));
              }
              if (aobjResourceSpansItem.resource->attributes->telemetry.sdk.version.isSome()) {
                writer.StringProperty("telemetry.sdk.version", *(aobjResourceSpansItem.resource->attributes->telemetry.sdk.version));
              }
              writer.EndObject();
            }
            writer.EndObject();
          }
          if (aobjResourceSpansItem.scope_spans.isSome()) {
            writer.StartArrayProperty("scope_spans");
            for (const auto& aobjresourcespansitemScopeSpansItem: *aobjResourceSpansItem.scope_spans) {
              writer.StartObjectElement();
              {
                if (aobjresourcespansitemScopeSpansItem.scope.isSome()) {
                  writer.StartObjectProperty("scope");
                  if (aobjresourcespansitemScopeSpansItem.scope->name.isSome()) {
                    writer.StringProperty("name", *(aobjresourcespansitemScopeSpansItem.scope->name));
                  }
                  writer.EndObject();
                }
                if (aobjresourcespansitemScopeSpansItem.spans.isSome()) {
                  writer.StartArrayProperty("spans");
                  for (const auto& aobjresourcespansitemscopespansitemSpansItem: *aobjresourcespansitemScopeSpansItem.spans) {
                    writer.StartObjectElement();
                    {
                      if (aobjresourcespansitemscopespansitemSpansItem.trace_id.isSome()) {
                        writer.StringProperty("trace_id", *(aobjresourcespansitemscopespansitemSpansItem.trace_id));
                      }
                      if (aobjresourcespansitemscopespansitemSpansItem.span_id.isSome()) {
                        writer.StringProperty("span_id", *(aobjresourcespansitemscopespansitemSpansItem.span_id));
                      }
                      if (aobjresourcespansitemscopespansitemSpansItem.parent_span_id.isSome()) {
                        writer.StringProperty("parent_span_id", *(aobjresourcespansitemscopespansitemSpansItem.parent_span_id));
                      }
                      if (aobjresourcespansitemscopespansitemSpansItem.name.isSome()) {
                        writer.StringProperty("name", *(aobjresourcespansitemscopespansitemSpansItem.name));
                      }
                      if (aobjresourcespansitemscopespansitemSpansItem.start_time_unix_nano.isSome()) {
                        writer.IntProperty("start_time_unix_nano", *(aobjresourcespansitemscopespansitemSpansItem.start_time_unix_nano));
                      }
                      if (aobjresourcespansitemscopespansitemSpansItem.end_time_unix_nano.isSome()) {
                        writer.IntProperty("end_time_unix_nano", *(aobjresourcespansitemscopespansitemSpansItem.end_time_unix_nano));
                      }
                      if (aobjresourcespansitemscopespansitemSpansItem.events.isSome()) {
                        writer.StartArrayProperty("events");
                        for (const auto& aobjresourcespansitemscopespansitemspansitemEventsItem: *aobjresourcespansitemscopespansitemSpansItem.events) {
                          writer.StartObjectElement();
                          {
                            if (aobjresourcespansitemscopespansitemspansitemEventsItem.name.isSome()) {
                              writer.StringProperty("name", *(aobjresourcespansitemscopespansitemspansitemEventsItem.name));
                            }
                            if (aobjresourcespansitemscopespansitemspansitemEventsItem.time_unix_nano.isSome()) {
                              writer.IntProperty("time_unix_nano", *(aobjresourcespansitemscopespansitemspansitemEventsItem.time_unix_nano));
                            }
                            if (aobjresourcespansitemscopespansitemspansitemEventsItem.attributes.isSome()) {
                              writer.StartObjectProperty("attributes");
                              if (aobjresourcespansitemscopespansitemspansitemEventsItem.attributes->source.file.isSome()) {
                                writer.StringProperty("source.file", *(aobjresourcespansitemscopespansitemspansitemEventsItem.attributes->source.file));
                              }
                              if (aobjresourcespansitemscopespansitemspansitemEventsItem.attributes->source.line.isSome()) {
                                writer.IntProperty("source.line", *(aobjresourcespansitemscopespansitemspansitemEventsItem.attributes->source.line));
                              }
                              if (aobjresourcespansitemscopespansitemspansitemEventsItem.attributes->frame_id.isSome()) {
                                writer.StringProperty("frame_id", *(aobjresourcespansitemscopespansitemspansitemEventsItem.attributes->frame_id));
                              }
                              if (aobjresourcespansitemscopespansitemspansitemEventsItem.attributes->result.isSome()) {
                                writer.StringProperty("result", *(aobjresourcespansitemscopespansitemspansitemEventsItem.attributes->result));
                              }
                              if (aobjresourcespansitemscopespansitemspansitemEventsItem.attributes->severity.isSome()) {
                                writer.StringProperty("severity", *(aobjresourcespansitemscopespansitemspansitemEventsItem.attributes->severity));
                              }
                              writer.EndObject();
                            }
                          }
                          writer.EndObject();

                        }
                        writer.EndArray();
                      }
                    }
                    writer.EndObject();

                  }
                  writer.EndArray();
                }
              }
              writer.EndObject();

            }
            writer.EndArray();
          }
        }
        writer.EndObject();

      }
      writer.EndArray();
    }
  }
  writer.EndObject();


  SetStr(json);
}

} // namespace mozilla::glean

#endif // mozilla_GleanGeckoTraceGeneratedMetrics_h
