// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanServicesFxaccountsMetrics_h
#define mozilla_GleanServicesFxaccountsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace client_association {
  /**
   * generated from client_association.legacy_client_id
   * The legacy Telemetry client ID associated with this user profile.
   */
  constexpr impl::UuidMetric legacy_client_id(4506);

  /**
   * generated from client_association.uid
   * The Mozilla Account UID associated with the user.
   */
  constexpr impl::StringMetric uid(4507);
}

namespace fxa {
  /**
   * generated from fxa.account_enabled
   * Whether the user's logged in to an FxA account.
   */
  constexpr impl::BooleanMetric account_enabled(4508);

  /**
   * generated from fxa.closetab_received
   */
  struct ClosetabReceivedExtra {
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> hashedDeviceId;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> serverTime;
    mozilla::Maybe<nsCString> streamId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (hashedDeviceId) {
        extraKeys.AppendElement()->AssignASCII("hashed_device_id");
        extraValues.EmplaceBack(hashedDeviceId.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (serverTime) {
        extraKeys.AppendElement()->AssignASCII("server_time");
        extraValues.EmplaceBack(serverTime.value());
      }
      if (streamId) {
        extraKeys.AppendElement()->AssignASCII("stream_id");
        extraValues.EmplaceBack(streamId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * We've received orders to close a tab.
   */
  constexpr impl::EventMetric<ClosetabReceivedExtra> closetab_received(4509);

  /**
   * generated from fxa.closetab_sent
   */
  struct ClosetabSentExtra {
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> hashedDeviceId;
    mozilla::Maybe<nsCString> serverTime;
    mozilla::Maybe<nsCString> streamId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (hashedDeviceId) {
        extraKeys.AppendElement()->AssignASCII("hashed_device_id");
        extraValues.EmplaceBack(hashedDeviceId.value());
      }
      if (serverTime) {
        extraKeys.AppendElement()->AssignASCII("server_time");
        extraValues.EmplaceBack(serverTime.value());
      }
      if (streamId) {
        extraKeys.AppendElement()->AssignASCII("stream_id");
        extraValues.EmplaceBack(streamId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User asked to close a tab on their other devices.
   */
  constexpr impl::EventMetric<ClosetabSentExtra> closetab_sent(4510);

  /**
   * generated from fxa.connect_account
   */
  struct ConnectAccountExtra {
    mozilla::Maybe<nsCString> fxa;
    mozilla::Maybe<nsCString> sync;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxa) {
        extraKeys.AppendElement()->AssignASCII("fxa");
        extraValues.EmplaceBack(fxa.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.EmplaceBack(sync.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records when a Firefox Account, or a Firefox Account service, is explicitly connected from the browser via an intentional user action. This event was generated to correspond to the Legacy Telemetry event fxa.connect#account.
   */
  constexpr impl::EventMetric<ConnectAccountExtra> connect_account(4511);

  /**
   * generated from fxa.disconnect_account
   */
  struct DisconnectAccountExtra {
    mozilla::Maybe<nsCString> fxa;
    mozilla::Maybe<nsCString> sync;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (fxa) {
        extraKeys.AppendElement()->AssignASCII("fxa");
        extraValues.EmplaceBack(fxa.value());
      }
      if (sync) {
        extraKeys.AppendElement()->AssignASCII("sync");
        extraValues.EmplaceBack(sync.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records when a Firefox Account, or a Firefox Account service, is explicitly disconnected from the browser via an intentional user action. This event was generated to correspond to the Legacy Telemetry event fxa.disconnect#account.
   */
  constexpr impl::EventMetric<DisconnectAccountExtra> disconnect_account(4512);

  /**
   * generated from fxa.sendtab_received
   */
  struct SendtabReceivedExtra {
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> hashedDeviceId;
    mozilla::Maybe<nsCString> reason;
    mozilla::Maybe<nsCString> serverTime;
    mozilla::Maybe<nsCString> streamId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (hashedDeviceId) {
        extraKeys.AppendElement()->AssignASCII("hashed_device_id");
        extraValues.EmplaceBack(hashedDeviceId.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      if (serverTime) {
        extraKeys.AppendElement()->AssignASCII("server_time");
        extraValues.EmplaceBack(serverTime.value());
      }
      if (streamId) {
        extraKeys.AppendElement()->AssignASCII("stream_id");
        extraValues.EmplaceBack(streamId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * We've received a sent tab.
   */
  constexpr impl::EventMetric<SendtabReceivedExtra> sendtab_received(4513);

  /**
   * generated from fxa.sendtab_sent
   */
  struct SendtabSentExtra {
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> hashedDeviceId;
    mozilla::Maybe<nsCString> serverTime;
    mozilla::Maybe<nsCString> streamId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (hashedDeviceId) {
        extraKeys.AppendElement()->AssignASCII("hashed_device_id");
        extraValues.EmplaceBack(hashedDeviceId.value());
      }
      if (serverTime) {
        extraKeys.AppendElement()->AssignASCII("server_time");
        extraValues.EmplaceBack(serverTime.value());
      }
      if (streamId) {
        extraKeys.AppendElement()->AssignASCII("stream_id");
        extraValues.EmplaceBack(streamId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User asked to send a tab to their devices.
   */
  constexpr impl::EventMetric<SendtabSentExtra> sendtab_sent(4514);

  /**
   * generated from fxa.sync_enabled
   * Whether the weave service is present and enabled.
   * Implies `fxa.account_enabled`.
   */
  constexpr impl::BooleanMetric sync_enabled(4515);
}

namespace sync_settings {
  /**
   * generated from sync_settings.open_choose_what_to_sync_menu
   */
  struct OpenChooseWhatToSyncMenuExtra {
    mozilla::Maybe<nsCString> why;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (why) {
        extraKeys.AppendElement()->AssignASCII("why");
        extraValues.EmplaceBack(why.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records when the user opens the choose what to sync menu.
   */
  constexpr impl::EventMetric<OpenChooseWhatToSyncMenuExtra> open_choose_what_to_sync_menu(4516);

  /**
   * generated from sync_settings.save
   */
  struct SaveExtra {
    mozilla::Maybe<nsCString> disabledEngines;
    mozilla::Maybe<nsCString> enabledEngines;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (disabledEngines) {
        extraKeys.AppendElement()->AssignASCII("disabled_engines");
        extraValues.EmplaceBack(disabledEngines.value());
      }
      if (enabledEngines) {
        extraKeys.AppendElement()->AssignASCII("enabled_engines");
        extraValues.EmplaceBack(enabledEngines.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Records when the user clicks the save button after opening the choose what to sync menu.
   */
  constexpr impl::EventMetric<SaveExtra> save(4517);
}

} // namespace mozilla::glean

#endif // mozilla_GleanServicesFxaccountsMetrics_h
