// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanTabbrowserMetrics_h
#define mozilla_GleanTabbrowserMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace browser_engagement {
  /**
   * generated from browser.engagement.tab_explicit_unload
   */
  struct TabExplicitUnloadExtra {
    mozilla::Maybe<bool> allTabsUnloaded;
    mozilla::Maybe<uint32_t> memoryAfter;
    mozilla::Maybe<uint32_t> memoryBefore;
    mozilla::Maybe<uint32_t> tabsUnloaded;
    mozilla::Maybe<uint32_t> timeToUnloadInMs;
    mozilla::Maybe<bool> unloadSelectedTab;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (allTabsUnloaded) {
        extraKeys.AppendElement()->AssignASCII("all_tabs_unloaded");
        extraValues.AppendElement()->AssignASCII(allTabsUnloaded.value() ? "true" : "false");
      }
      if (memoryAfter) {
        extraKeys.AppendElement()->AssignASCII("memory_after");
        extraValues.AppendElement()->AppendInt(memoryAfter.value());
      }
      if (memoryBefore) {
        extraKeys.AppendElement()->AssignASCII("memory_before");
        extraValues.AppendElement()->AppendInt(memoryBefore.value());
      }
      if (tabsUnloaded) {
        extraKeys.AppendElement()->AssignASCII("tabs_unloaded");
        extraValues.AppendElement()->AppendInt(tabsUnloaded.value());
      }
      if (timeToUnloadInMs) {
        extraKeys.AppendElement()->AssignASCII("time_to_unload_in_ms");
        extraValues.AppendElement()->AppendInt(timeToUnloadInMs.value());
      }
      if (unloadSelectedTab) {
        extraKeys.AppendElement()->AssignASCII("unload_selected_tab");
        extraValues.AppendElement()->AssignASCII(unloadSelectedTab.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user explicitly unloads tab(s) from memory via the tab context menu.
   */
  constexpr impl::EventMetric<TabExplicitUnloadExtra> tab_explicit_unload(16);

  /**
   * generated from browser.engagement.tab_reload_count
   * The count of tab reload events by the user after unloaded. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.tab_reload_count.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> tab_reload_count(17);

  /**
   * generated from browser.engagement.tab_unload_count
   * The count of tab unload events by TabUnloader due to a low-memory situation. This metric was generated to correspond to the Legacy Telemetry scalar browser.engagement.tab_unload_count.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> tab_unload_count(18);

  /**
   * generated from browser.engagement.tab_unload_to_reload
   * How long (sec) a tab had been unloaded until it was reloaded.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram TAB_UNLOAD_TO_RELOAD.
   */
  constexpr impl::TimingDistributionMetric tab_unload_to_reload(19);
}

namespace browser_tabclose {
  /**
   * generated from browser.tabclose.permit_unload_time
   * Firefox: Time taken to run permitUnload on a browser during tab close to see whether or not we're allowed to close the tab (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_TAB_CLOSE_PERMIT_UNLOAD_TIME_MS.
   */
  constexpr impl::TimingDistributionMetric permit_unload_time(915);

  /**
   * generated from browser.tabclose.time_anim
   * Firefox: Time taken from the point of closing a tab (with animation), to the browser element being removed from the DOM. (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_TAB_CLOSE_TIME_ANIM_MS.
   */
  constexpr impl::TimingDistributionMetric time_anim(916);

  /**
   * generated from browser.tabclose.time_no_anim
   * Firefox: Time taken from the point of closing a tab (without animation) to the browser element being removed from the DOM. (ms).
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_TAB_CLOSE_TIME_NO_ANIM_MS.
   */
  constexpr impl::TimingDistributionMetric time_no_anim(917);
}

namespace browser_tabswitch {
  /**
   * generated from browser.tabswitch.spinner_visible
   * Firefox: If the spinner interstitial displays during tab switching, records the time in ms the graphic is visible
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_TAB_SWITCH_SPINNER_VISIBLE_MS.
   */
  constexpr impl::TimingDistributionMetric spinner_visible(918);

  /**
   * generated from browser.tabswitch.spinner_visible_trigger
   */
  enum class SpinnerVisibleTriggerLabel: uint16_t {
    eNone = 0,
    ePreactions = 1,
    ePostactions = 2,
    eOnloadtimeout = 3,
    eOnlayersready = 4,
    eOnsizemodeorocc = 5,
    eOnendswapdocshells = 6,
    e__Other__,
  };
  /**
   * Diagnostic probe to aid in categorizing tab switch spinners. Records what most recently set the loadTimer to null if a spinner was displayed.
   * This metric was generated to correspond to the Legacy Telemetry categorical histogram FX_TAB_SWITCH_SPINNER_VISIBLE_TRIGGER.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, SpinnerVisibleTriggerLabel> spinner_visible_trigger(919);

  /**
   * generated from browser.tabswitch.total
   * Firefox: Time in ms between tab selection and tab content paint in e10s windows
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_TAB_SWITCH_TOTAL_E10S_MS.
   */
  constexpr impl::TimingDistributionMetric total(920);

  /**
   * generated from browser.tabswitch.update
   * Firefox: Time in ms spent updating UI in response to a tab switch
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram FX_TAB_SWITCH_UPDATE_MS.
   */
  constexpr impl::TimingDistributionMetric update(921);
}

namespace browser_ui_interaction {
  /**
   * generated from browser.ui.interaction.all_tabs_panel_dragstart_tab_event_count
   * Records a count of how many times a drag event started for a tab within the All Tabs panel. This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.all_tabs_panel_dragstart_tab_event_count.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> all_tabs_panel_dragstart_tab_event_count(922);

  /**
   * generated from browser.ui.interaction.all_tabs_panel_entrypoint
   * Records a count of how many times the All Tabs Panel was opened, keyed on a string describing the entrypoint. This metric was generated to correspond to the Legacy Telemetry scalar browser.ui.interaction.all_tabs_panel_entrypoint.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, DynamicLabel> all_tabs_panel_entrypoint(923);

  /**
   * generated from browser.ui.interaction.list_all_tabs_action
   */
  enum class ListAllTabsActionLabel: uint16_t {
    eCloseAllDuplicates = 0,
    eTabsFromDevices = 1,
    eSearchTabs = 2,
    e__Other__,
  };
  /**
   * Records how often users interact with any top-level menu option in the "List All Tabs" menu.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, ListAllTabsActionLabel> list_all_tabs_action(924);

  /**
   * generated from browser.ui.interaction.tab_movement
   */
  enum class TabMovementLabel: uint16_t {
    eNotFromExternalApp = 0,
    eFromExternalAppNextToActiveTab = 1,
    eFromExternalAppTabStripEnd = 2,
    e__Other__,
  };
  /**
   * Records information about user tab movements within the tab strip.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, TabMovementLabel> tab_movement(925);
}

namespace link_handling {
  /**
   * generated from link.handling.open_from_external_app
   */
  struct OpenFromExternalAppExtra {
    mozilla::Maybe<bool> nextToActiveTab;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (nextToActiveTab) {
        extraKeys.AppendElement()->AssignASCII("next_to_active_tab");
        extraValues.AppendElement()->AssignASCII(nextToActiveTab.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded when a link is clicked outside of Firefox and this external link is then opened inside of Firefox. The "Open links from apps next to your active tab" option governs the behavior of where the link will be opened.
   */
  constexpr impl::EventMetric<OpenFromExternalAppExtra> open_from_external_app(952);

  /**
   * generated from link.handling.open_next_to_active_tab_settings_change
   */
  struct OpenNextToActiveTabSettingsChangeExtra {
    mozilla::Maybe<bool> checked;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (checked) {
        extraKeys.AppendElement()->AssignASCII("checked");
        extraValues.AppendElement()->AssignASCII(checked.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * This is recorded when the "Open links from apps next to your active tab" checkbox in the General > Tabs section of about:preferences is toggled.
   */
  constexpr impl::EventMetric<OpenNextToActiveTabSettingsChangeExtra> open_next_to_active_tab_settings_change(953);

  /**
   * generated from link.handling.open_next_to_active_tab_settings_enabled
   * Records if the user has the "Open links from apps next to your active tab" feature enabled.
   */
  constexpr impl::BooleanMetric open_next_to_active_tab_settings_enabled(954);
}

namespace tabgroup {
  /**
   * generated from tabgroup.active_groups
   */
  enum class ActiveGroupsLabel: uint16_t {
    eExpanded = 0,
    eCollapsed = 1,
    e__Other__,
  };
  /**
   * Records the number of groups present in the tab bar, split by expanded or collapsed.
   */
  constexpr impl::Labeled<impl::QuantityMetric, ActiveGroupsLabel> active_groups(955);

  /**
   * generated from tabgroup.add_tab
   */
  struct AddTabExtra {
    mozilla::Maybe<nsCString> groupType;
    mozilla::Maybe<nsCString> layout;
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<uint32_t> tabs;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (groupType) {
        extraKeys.AppendElement()->AssignASCII("group_type");
        extraValues.EmplaceBack(groupType.value());
      }
      if (layout) {
        extraKeys.AppendElement()->AssignASCII("layout");
        extraValues.EmplaceBack(layout.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (tabs) {
        extraKeys.AppendElement()->AssignASCII("tabs");
        extraValues.AppendElement()->AppendInt(tabs.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user adds one or more ungrouped tabs to an existing tab group
   */
  constexpr impl::EventMetric<AddTabExtra> add_tab(956);

  /**
   * generated from tabgroup.create_group
   */
  struct CreateGroupExtra {
    mozilla::Maybe<nsCString> id;
    mozilla::Maybe<nsCString> layout;
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<uint32_t> tabs;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (id) {
        extraKeys.AppendElement()->AssignASCII("id");
        extraValues.EmplaceBack(id.value());
      }
      if (layout) {
        extraKeys.AppendElement()->AssignASCII("layout");
        extraValues.EmplaceBack(layout.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (tabs) {
        extraKeys.AppendElement()->AssignASCII("tabs");
        extraValues.AppendElement()->AppendInt(tabs.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user creates a new tab group via the tab context menu or through drag and drop.
   */
  constexpr impl::EventMetric<CreateGroupExtra> create_group(957);

  /**
   * generated from tabgroup.delete
   */
  struct DeleteExtra {
    mozilla::Maybe<nsCString> id;
    mozilla::Maybe<nsCString> source;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (id) {
        extraKeys.AppendElement()->AssignASCII("id");
        extraValues.EmplaceBack(id.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user deletes a tab group
   */
  constexpr impl::EventMetric<DeleteExtra> delete(958);

  /**
   * generated from tabgroup.group_interactions
   */
  enum class GroupInteractionsLabel: uint16_t {
    eExpand = 0,
    eCollapse = 1,
    eRename = 2,
    eChangeColor = 3,
    eSave = 4,
    eReopen = 5,
    eOpenTabmenu = 6,
    eOpenRecent = 7,
    eOpenSuggest = 8,
    eDelete = 9,
    eUngroup = 10,
    eMoveWindow = 11,
    eHoverPreview = 12,
    e__Other__,
  };
  /**
   * Records interactions with tab groups: expand/collapse; rename, change color; save/reopen/delete; ungroup tabs; open from tab menu/recent/ Awesomebar; move to another window
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, GroupInteractionsLabel> group_interactions(959);

  /**
   * generated from tabgroup.reopen
   */
  struct ReopenExtra {
    mozilla::Maybe<nsCString> id;
    mozilla::Maybe<nsCString> layout;
    mozilla::Maybe<nsCString> source;
    mozilla::Maybe<nsCString> type;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (id) {
        extraKeys.AppendElement()->AssignASCII("id");
        extraValues.EmplaceBack(id.value());
      }
      if (layout) {
        extraKeys.AppendElement()->AssignASCII("layout");
        extraValues.EmplaceBack(layout.value());
      }
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      if (type) {
        extraKeys.AppendElement()->AssignASCII("type");
        extraValues.EmplaceBack(type.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when a user reopens a saved tab group
   */
  constexpr impl::EventMetric<ReopenExtra> reopen(960);

  /**
   * generated from tabgroup.save
   */
  struct SaveExtra {
    mozilla::Maybe<nsCString> id;
    mozilla::Maybe<bool> userTriggered;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (id) {
        extraKeys.AppendElement()->AssignASCII("id");
        extraValues.EmplaceBack(id.value());
      }
      if (userTriggered) {
        extraKeys.AppendElement()->AssignASCII("user_triggered");
        extraValues.AppendElement()->AssignASCII(userTriggered.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user saves a tab group
   */
  constexpr impl::EventMetric<SaveExtra> save(961);

  /**
   * generated from tabgroup.saved_groups
   * Records the number of saved tab groups present in the user's session
   */
  constexpr impl::QuantityMetric saved_groups(962);

  /**
   * generated from tabgroup.smart_tab
   */
  struct SmartTabExtra {
    mozilla::Maybe<bool> enabled;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (enabled) {
        extraKeys.AppendElement()->AssignASCII("enabled");
        extraValues.AppendElement()->AssignASCII(enabled.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when any pref cause smart tabs to be enabled / disabled
   */
  constexpr impl::EventMetric<SmartTabExtra> smart_tab(963);

  /**
   * generated from tabgroup.smart_tab_enabled
   * Records if the user has smart tab groups enabled
   */
  constexpr impl::BooleanMetric smart_tab_enabled(964);

  /**
   * generated from tabgroup.smart_tab_optin
   */
  struct SmartTabOptinExtra {
    mozilla::Maybe<nsCString> step;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (step) {
        extraKeys.AppendElement()->AssignASCII("step");
        extraValues.EmplaceBack(step.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when onboards to smart tab grouping through opt-in UI
   */
  constexpr impl::EventMetric<SmartTabOptinExtra> smart_tab_optin(965);

  /**
   * generated from tabgroup.smart_tab_suggest
   */
  struct SmartTabSuggestExtra {
    mozilla::Maybe<nsCString> action;
    mozilla::Maybe<nsCString> backend;
    mozilla::Maybe<nsCString> id;
    mozilla::Maybe<nsCString> modelRevision;
    mozilla::Maybe<uint32_t> tabsApproved;
    mozilla::Maybe<uint32_t> tabsInGroup;
    mozilla::Maybe<uint32_t> tabsInWindow;
    mozilla::Maybe<uint32_t> tabsRemoved;
    mozilla::Maybe<uint32_t> tabsSuggested;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (action) {
        extraKeys.AppendElement()->AssignASCII("action");
        extraValues.EmplaceBack(action.value());
      }
      if (backend) {
        extraKeys.AppendElement()->AssignASCII("backend");
        extraValues.EmplaceBack(backend.value());
      }
      if (id) {
        extraKeys.AppendElement()->AssignASCII("id");
        extraValues.EmplaceBack(id.value());
      }
      if (modelRevision) {
        extraKeys.AppendElement()->AssignASCII("model_revision");
        extraValues.EmplaceBack(modelRevision.value());
      }
      if (tabsApproved) {
        extraKeys.AppendElement()->AssignASCII("tabs_approved");
        extraValues.AppendElement()->AppendInt(tabsApproved.value());
      }
      if (tabsInGroup) {
        extraKeys.AppendElement()->AssignASCII("tabs_in_group");
        extraValues.AppendElement()->AppendInt(tabsInGroup.value());
      }
      if (tabsInWindow) {
        extraKeys.AppendElement()->AssignASCII("tabs_in_window");
        extraValues.AppendElement()->AppendInt(tabsInWindow.value());
      }
      if (tabsRemoved) {
        extraKeys.AppendElement()->AssignASCII("tabs_removed");
        extraValues.AppendElement()->AppendInt(tabsRemoved.value());
      }
      if (tabsSuggested) {
        extraKeys.AppendElement()->AssignASCII("tabs_suggested");
        extraValues.AppendElement()->AppendInt(tabsSuggested.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user saves suggested tabs using the ml embedding model
   */
  constexpr impl::EventMetric<SmartTabSuggestExtra> smart_tab_suggest(966);

  /**
   * generated from tabgroup.smart_tab_topic
   */
  struct SmartTabTopicExtra {
    mozilla::Maybe<nsCString> action;
    mozilla::Maybe<nsCString> backend;
    mozilla::Maybe<nsCString> id;
    mozilla::Maybe<nsCString> labelReason;
    mozilla::Maybe<uint32_t> levenshteinDistance;
    mozilla::Maybe<uint32_t> mlLabelLength;
    mozilla::Maybe<nsCString> modelRevision;
    mozilla::Maybe<uint32_t> tabsInGroup;
    mozilla::Maybe<uint32_t> userLabelLength;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (action) {
        extraKeys.AppendElement()->AssignASCII("action");
        extraValues.EmplaceBack(action.value());
      }
      if (backend) {
        extraKeys.AppendElement()->AssignASCII("backend");
        extraValues.EmplaceBack(backend.value());
      }
      if (id) {
        extraKeys.AppendElement()->AssignASCII("id");
        extraValues.EmplaceBack(id.value());
      }
      if (labelReason) {
        extraKeys.AppendElement()->AssignASCII("label_reason");
        extraValues.EmplaceBack(labelReason.value());
      }
      if (levenshteinDistance) {
        extraKeys.AppendElement()->AssignASCII("levenshtein_distance");
        extraValues.AppendElement()->AppendInt(levenshteinDistance.value());
      }
      if (mlLabelLength) {
        extraKeys.AppendElement()->AssignASCII("ml_label_length");
        extraValues.AppendElement()->AppendInt(mlLabelLength.value());
      }
      if (modelRevision) {
        extraKeys.AppendElement()->AssignASCII("model_revision");
        extraValues.EmplaceBack(modelRevision.value());
      }
      if (tabsInGroup) {
        extraKeys.AppendElement()->AssignASCII("tabs_in_group");
        extraValues.AppendElement()->AppendInt(tabsInGroup.value());
      }
      if (userLabelLength) {
        extraKeys.AppendElement()->AssignASCII("user_label_length");
        extraValues.AppendElement()->AppendInt(userLabelLength.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user saves a tab group label with the ml topic model
   */
  constexpr impl::EventMetric<SmartTabTopicExtra> smart_tab_topic(967);

  /**
   * generated from tabgroup.tab_count_in_groups
   */
  enum class TabCountInGroupsLabel: uint16_t {
    eInside = 0,
    eOutside = 1,
    e__Other__,
  };
  /**
   * Records the latest number of tabs in the tab bar, split by being inside a group or outside.
   */
  constexpr impl::Labeled<impl::QuantityMetric, TabCountInGroupsLabel> tab_count_in_groups(968);

  /**
   * generated from tabgroup.tab_interactions
   */
  enum class TabInteractionsLabel: uint16_t {
    eActivateExpanded = 0,
    eActivateCollapsed = 1,
    eAdd = 2,
    eDuplicate = 3,
    eNew = 4,
    eCloseTabstrip = 5,
    eCloseTabmenu = 6,
    eCloseTabOther = 7,
    eReorder = 8,
    eRemoveSameWindow = 9,
    eRemoveOtherWindow = 10,
    eRemoveNewWindow = 11,
    e__Other__,
  };
  /**
   * Records interactions with tabs related to a group: open, add tab to group, duplicate, create a new tab, close a tab, reorder, and remove from group
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, TabInteractionsLabel> tab_interactions(969);

  /**
   * generated from tabgroup.tabs_per_active_group
   */
  enum class TabsPerActiveGroupLabel: uint16_t {
    eMax = 0,
    eMedian = 1,
    eAverage = 2,
    eMin = 3,
    e__Other__,
  };
  /**
   * Records statistics about the number of tabs per active group: max, median, average and min.
   */
  constexpr impl::Labeled<impl::QuantityMetric, TabsPerActiveGroupLabel> tabs_per_active_group(970);

  /**
   * generated from tabgroup.tabs_per_saved_group
   */
  enum class TabsPerSavedGroupLabel: uint16_t {
    eMax = 0,
    eMedian = 1,
    eAverage = 2,
    eMin = 3,
    e__Other__,
  };
  /**
   * Records statistics about the number of tabs per saved tab group: max, median, average and min.
   */
  constexpr impl::Labeled<impl::QuantityMetric, TabsPerSavedGroupLabel> tabs_per_saved_group(971);

  /**
   * generated from tabgroup.ungroup
   */
  struct UngroupExtra {
    mozilla::Maybe<nsCString> source;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (source) {
        extraKeys.AppendElement()->AssignASCII("source");
        extraValues.EmplaceBack(source.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Recorded when the user ungroups all tabs of a tab group
   */
  constexpr impl::EventMetric<UngroupExtra> ungroup(972);
}

} // namespace mozilla::glean

#endif // mozilla_GleanTabbrowserMetrics_h
