// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanTaskbartabsMetrics_h
#define mozilla_GleanTaskbartabsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace web_app {
  /**
   * generated from web_app.activate
   */
  /**
   * A new taskbar tab window was opened.
   */
  constexpr impl::EventMetric<NoExtraKeys> activate(973);

  /**
   * generated from web_app.eject
   */
  /**
   * The user moved a tab from the taskbar into the browser.
   */
  constexpr impl::EventMetric<NoExtraKeys> eject(974);

  /**
   * generated from web_app.install
   */
  /**
   * The user installed a new web app.
   */
  constexpr impl::EventMetric<NoExtraKeys> install(975);

  /**
   * generated from web_app.installed_web_app_count
   * Count of currently installed web apps. Note that Firefox does not detect unpinning or deleting the shortcut outside of Firefox, so this could include web apps that the user has no way to access; see bug 1990342.
   */
  constexpr impl::QuantityMetric installed_web_app_count(976);

  /**
   * generated from web_app.move_to_taskbar
   */
  /**
   * The user moved a tab onto the taskbar.
   */
  constexpr impl::EventMetric<NoExtraKeys> move_to_taskbar(977);

  /**
   * generated from web_app.pin
   */
  struct PinExtra {
    mozilla::Maybe<nsCString> result;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (result) {
        extraKeys.AppendElement()->AssignASCII("result");
        extraValues.EmplaceBack(result.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The user pinned the web app to their taskbar using Firefox.
   */
  constexpr impl::EventMetric<PinExtra> pin(978);

  /**
   * generated from web_app.uninstall
   */
  /**
   * The user uninstalled a web app using the page action.
   */
  constexpr impl::EventMetric<NoExtraKeys> uninstall(979);

  /**
   * generated from web_app.unpin
   */
  struct UnpinExtra {
    mozilla::Maybe<nsCString> removalResult;
    mozilla::Maybe<nsCString> result;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (removalResult) {
        extraKeys.AppendElement()->AssignASCII("removal_result");
        extraValues.EmplaceBack(removalResult.value());
      }
      if (result) {
        extraKeys.AppendElement()->AssignASCII("result");
        extraValues.EmplaceBack(result.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The user unpinned the web app from their taskbar using Firefox.
   */
  constexpr impl::EventMetric<UnpinExtra> unpin(980);

  /**
   * generated from web_app.usage_time
   * Time that the user has the Taskbar Tab focused.
   */
  constexpr impl::TimingDistributionMetric usage_time(981);
}

} // namespace mozilla::glean

#endif // mozilla_GleanTaskbartabsMetrics_h
