// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanToolkitContentMetrics_h
#define mozilla_GleanToolkitContentMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace findbar {
  /**
   * generated from findbar.find_next
   * The count of how many times the find next button was used per session. This metric was generated to correspond to the Legacy Telemetry scalar findbar.find_next.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> find_next(5855);

  /**
   * generated from findbar.find_prev
   * The count of how many times the find previous button was used per session. This metric was generated to correspond to the Legacy Telemetry scalar findbar.find_prev.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> find_prev(5856);

  /**
   * generated from findbar.highlight_all
   * The count of how many times the "Highlight All" button was used in find toolbar. This metric was generated to correspond to the Legacy Telemetry scalar findbar.highlight_all.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> highlight_all(5857);

  /**
   * generated from findbar.match_case
   * The count of how many times the "Match Case" button was used in find toolbar. This metric was generated to correspond to the Legacy Telemetry scalar findbar.match_case.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> match_case(5858);

  /**
   * generated from findbar.match_diacritics
   * The count of how many times the "Match Diacritics" button was used in find toolbar. This metric was generated to correspond to the Legacy Telemetry scalar findbar.match_diacritics.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> match_diacritics(5859);

  /**
   * generated from findbar.shown
   * The count of how many times the "Find toolbar" was shown per session. This metric was generated to correspond to the Legacy Telemetry scalar findbar.shown.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> shown(5860);

  /**
   * generated from findbar.whole_words
   * The count of how many times the "Whole Words" button was used in find toolbar. This metric was generated to correspond to the Legacy Telemetry scalar findbar.whole_words.
   */
  constexpr impl::CounterMetric<impl::CounterType::eBaseOrLabeled> whole_words(5861);
}

namespace security_doh_neterror {
  /**
   * generated from security.doh.neterror.click_add_exception_button
   */
  struct ClickAddExceptionButtonExtra {
    mozilla::Maybe<nsCString> mode;
    mozilla::Maybe<nsCString> providerKey;
    mozilla::Maybe<nsCString> skipReason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (mode) {
        extraKeys.AppendElement()->AssignASCII("mode");
        extraValues.EmplaceBack(mode.value());
      }
      if (providerKey) {
        extraKeys.AppendElement()->AssignASCII("provider_key");
        extraValues.EmplaceBack(providerKey.value());
      }
      if (skipReason) {
        extraKeys.AppendElement()->AssignASCII("skip_reason");
        extraValues.EmplaceBack(skipReason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click buttons on the DoH warning page. This event was generated to correspond to the Legacy Telemetry event security.doh.neterror.click#add_exception_button.
   */
  constexpr impl::EventMetric<ClickAddExceptionButtonExtra> click_add_exception_button(5862);

  /**
   * generated from security.doh.neterror.click_continue_button
   */
  struct ClickContinueButtonExtra {
    mozilla::Maybe<nsCString> mode;
    mozilla::Maybe<nsCString> providerKey;
    mozilla::Maybe<nsCString> skipReason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (mode) {
        extraKeys.AppendElement()->AssignASCII("mode");
        extraValues.EmplaceBack(mode.value());
      }
      if (providerKey) {
        extraKeys.AppendElement()->AssignASCII("provider_key");
        extraValues.EmplaceBack(providerKey.value());
      }
      if (skipReason) {
        extraKeys.AppendElement()->AssignASCII("skip_reason");
        extraValues.EmplaceBack(skipReason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click buttons on the DoH warning page. This event was generated to correspond to the Legacy Telemetry event security.doh.neterror.click#continue_button.
   */
  constexpr impl::EventMetric<ClickContinueButtonExtra> click_continue_button(5863);

  /**
   * generated from security.doh.neterror.click_disable_warning
   */
  struct ClickDisableWarningExtra {
    mozilla::Maybe<nsCString> mode;
    mozilla::Maybe<nsCString> providerKey;
    mozilla::Maybe<nsCString> skipReason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (mode) {
        extraKeys.AppendElement()->AssignASCII("mode");
        extraValues.EmplaceBack(mode.value());
      }
      if (providerKey) {
        extraKeys.AppendElement()->AssignASCII("provider_key");
        extraValues.EmplaceBack(providerKey.value());
      }
      if (skipReason) {
        extraKeys.AppendElement()->AssignASCII("skip_reason");
        extraValues.EmplaceBack(skipReason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click buttons on the DoH warning page. This event was generated to correspond to the Legacy Telemetry event security.doh.neterror.click#disable_warning.
   */
  constexpr impl::EventMetric<ClickDisableWarningExtra> click_disable_warning(5864);

  /**
   * generated from security.doh.neterror.click_learn_more_link
   */
  struct ClickLearnMoreLinkExtra {
    mozilla::Maybe<nsCString> mode;
    mozilla::Maybe<nsCString> providerKey;
    mozilla::Maybe<nsCString> skipReason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (mode) {
        extraKeys.AppendElement()->AssignASCII("mode");
        extraValues.EmplaceBack(mode.value());
      }
      if (providerKey) {
        extraKeys.AppendElement()->AssignASCII("provider_key");
        extraValues.EmplaceBack(providerKey.value());
      }
      if (skipReason) {
        extraKeys.AppendElement()->AssignASCII("skip_reason");
        extraValues.EmplaceBack(skipReason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click buttons on the DoH warning page. This event was generated to correspond to the Legacy Telemetry event security.doh.neterror.click#learn_more_link.
   */
  constexpr impl::EventMetric<ClickLearnMoreLinkExtra> click_learn_more_link(5865);

  /**
   * generated from security.doh.neterror.click_settings_button
   */
  struct ClickSettingsButtonExtra {
    mozilla::Maybe<nsCString> mode;
    mozilla::Maybe<nsCString> providerKey;
    mozilla::Maybe<nsCString> skipReason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (mode) {
        extraKeys.AppendElement()->AssignASCII("mode");
        extraValues.EmplaceBack(mode.value());
      }
      if (providerKey) {
        extraKeys.AppendElement()->AssignASCII("provider_key");
        extraValues.EmplaceBack(providerKey.value());
      }
      if (skipReason) {
        extraKeys.AppendElement()->AssignASCII("skip_reason");
        extraValues.EmplaceBack(skipReason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click buttons on the DoH warning page. This event was generated to correspond to the Legacy Telemetry event security.doh.neterror.click#settings_button.
   */
  constexpr impl::EventMetric<ClickSettingsButtonExtra> click_settings_button(5866);

  /**
   * generated from security.doh.neterror.click_try_again_button
   */
  struct ClickTryAgainButtonExtra {
    mozilla::Maybe<nsCString> mode;
    mozilla::Maybe<nsCString> providerKey;
    mozilla::Maybe<nsCString> skipReason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (mode) {
        extraKeys.AppendElement()->AssignASCII("mode");
        extraValues.EmplaceBack(mode.value());
      }
      if (providerKey) {
        extraKeys.AppendElement()->AssignASCII("provider_key");
        extraValues.EmplaceBack(providerKey.value());
      }
      if (skipReason) {
        extraKeys.AppendElement()->AssignASCII("skip_reason");
        extraValues.EmplaceBack(skipReason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click buttons on the DoH warning page. This event was generated to correspond to the Legacy Telemetry event security.doh.neterror.click#try_again_button.
   */
  constexpr impl::EventMetric<ClickTryAgainButtonExtra> click_try_again_button(5867);

  /**
   * generated from security.doh.neterror.load_dohwarning
   */
  struct LoadDohwarningExtra {
    mozilla::Maybe<uint32_t> mode;
    mozilla::Maybe<nsCString> providerKey;
    mozilla::Maybe<nsCString> skipReason;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (mode) {
        extraKeys.AppendElement()->AssignASCII("mode");
        extraValues.AppendElement()->AppendInt(mode.value());
      }
      if (providerKey) {
        extraKeys.AppendElement()->AssignASCII("provider_key");
        extraValues.EmplaceBack(providerKey.value());
      }
      if (skipReason) {
        extraKeys.AppendElement()->AssignASCII("skip_reason");
        extraValues.EmplaceBack(skipReason.value());
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The DoH warning page is loaded. This event was generated to correspond to the Legacy Telemetry event security.doh.neterror.load#dohwarning.
   */
  constexpr impl::EventMetric<LoadDohwarningExtra> load_dohwarning(5868);
}

namespace security_ui_certerror {
  /**
   * generated from security.ui.certerror.click_advanced_button
   */
  struct ClickAdvancedButtonExtra {
    mozilla::Maybe<bool> hasSts;
    mozilla::Maybe<bool> isFrame;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hasSts) {
        extraKeys.AppendElement()->AssignASCII("has_sts");
        extraValues.AppendElement()->AssignASCII(hasSts.value() ? "true" : "false");
      }
      if (isFrame) {
        extraKeys.AppendElement()->AssignASCII("is_frame");
        extraValues.AppendElement()->AssignASCII(isFrame.value() ? "true" : "false");
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click events on the cert error page. Keyed by error code, see https://searchfox.org/mozilla- central/source/security/nss/lib/mozpkix/include/pkix/Result.h This event was generated to correspond to the Legacy Telemetry event security.ui.certerror.click#advanced_button.
   */
  constexpr impl::EventMetric<ClickAdvancedButtonExtra> click_advanced_button(5869);

  /**
   * generated from security.ui.certerror.click_auto_report_cb
   */
  struct ClickAutoReportCbExtra {
    mozilla::Maybe<bool> hasSts;
    mozilla::Maybe<bool> isFrame;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hasSts) {
        extraKeys.AppendElement()->AssignASCII("has_sts");
        extraValues.AppendElement()->AssignASCII(hasSts.value() ? "true" : "false");
      }
      if (isFrame) {
        extraKeys.AppendElement()->AssignASCII("is_frame");
        extraValues.AppendElement()->AssignASCII(isFrame.value() ? "true" : "false");
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click events on the cert error page. Keyed by error code, see https://searchfox.org/mozilla- central/source/security/nss/lib/mozpkix/include/pkix/Result.h This event was generated to correspond to the Legacy Telemetry event security.ui.certerror.click#auto_report_cb.
   */
  constexpr impl::EventMetric<ClickAutoReportCbExtra> click_auto_report_cb(5870);

  /**
   * generated from security.ui.certerror.click_clipboard_button_bot
   */
  struct ClickClipboardButtonBotExtra {
    mozilla::Maybe<bool> hasSts;
    mozilla::Maybe<bool> isFrame;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hasSts) {
        extraKeys.AppendElement()->AssignASCII("has_sts");
        extraValues.AppendElement()->AssignASCII(hasSts.value() ? "true" : "false");
      }
      if (isFrame) {
        extraKeys.AppendElement()->AssignASCII("is_frame");
        extraValues.AppendElement()->AssignASCII(isFrame.value() ? "true" : "false");
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click events on the cert error page. Keyed by error code, see https://searchfox.org/mozilla- central/source/security/nss/lib/mozpkix/include/pkix/Result.h This event was generated to correspond to the Legacy Telemetry event security.ui.certerror.click#clipboard_button_bot.
   */
  constexpr impl::EventMetric<ClickClipboardButtonBotExtra> click_clipboard_button_bot(5871);

  /**
   * generated from security.ui.certerror.click_clipboard_button_top
   */
  struct ClickClipboardButtonTopExtra {
    mozilla::Maybe<bool> hasSts;
    mozilla::Maybe<bool> isFrame;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hasSts) {
        extraKeys.AppendElement()->AssignASCII("has_sts");
        extraValues.AppendElement()->AssignASCII(hasSts.value() ? "true" : "false");
      }
      if (isFrame) {
        extraKeys.AppendElement()->AssignASCII("is_frame");
        extraValues.AppendElement()->AssignASCII(isFrame.value() ? "true" : "false");
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click events on the cert error page. Keyed by error code, see https://searchfox.org/mozilla- central/source/security/nss/lib/mozpkix/include/pkix/Result.h This event was generated to correspond to the Legacy Telemetry event security.ui.certerror.click#clipboard_button_top.
   */
  constexpr impl::EventMetric<ClickClipboardButtonTopExtra> click_clipboard_button_top(5872);

  /**
   * generated from security.ui.certerror.click_error_code_link
   */
  struct ClickErrorCodeLinkExtra {
    mozilla::Maybe<bool> hasSts;
    mozilla::Maybe<bool> isFrame;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hasSts) {
        extraKeys.AppendElement()->AssignASCII("has_sts");
        extraValues.AppendElement()->AssignASCII(hasSts.value() ? "true" : "false");
      }
      if (isFrame) {
        extraKeys.AppendElement()->AssignASCII("is_frame");
        extraValues.AppendElement()->AssignASCII(isFrame.value() ? "true" : "false");
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click events on the cert error page. Keyed by error code, see https://searchfox.org/mozilla- central/source/security/nss/lib/mozpkix/include/pkix/Result.h This event was generated to correspond to the Legacy Telemetry event security.ui.certerror.click#error_code_link.
   */
  constexpr impl::EventMetric<ClickErrorCodeLinkExtra> click_error_code_link(5873);

  /**
   * generated from security.ui.certerror.click_exception_button
   */
  struct ClickExceptionButtonExtra {
    mozilla::Maybe<bool> hasSts;
    mozilla::Maybe<bool> isFrame;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hasSts) {
        extraKeys.AppendElement()->AssignASCII("has_sts");
        extraValues.AppendElement()->AssignASCII(hasSts.value() ? "true" : "false");
      }
      if (isFrame) {
        extraKeys.AppendElement()->AssignASCII("is_frame");
        extraValues.AppendElement()->AssignASCII(isFrame.value() ? "true" : "false");
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click events on the cert error page. Keyed by error code, see https://searchfox.org/mozilla- central/source/security/nss/lib/mozpkix/include/pkix/Result.h This event was generated to correspond to the Legacy Telemetry event security.ui.certerror.click#exception_button.
   */
  constexpr impl::EventMetric<ClickExceptionButtonExtra> click_exception_button(5874);

  /**
   * generated from security.ui.certerror.click_learn_more_link
   */
  struct ClickLearnMoreLinkExtra {
    mozilla::Maybe<bool> hasSts;
    mozilla::Maybe<bool> isFrame;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hasSts) {
        extraKeys.AppendElement()->AssignASCII("has_sts");
        extraValues.AppendElement()->AssignASCII(hasSts.value() ? "true" : "false");
      }
      if (isFrame) {
        extraKeys.AppendElement()->AssignASCII("is_frame");
        extraValues.AppendElement()->AssignASCII(isFrame.value() ? "true" : "false");
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click events on the cert error page. Keyed by error code, see https://searchfox.org/mozilla- central/source/security/nss/lib/mozpkix/include/pkix/Result.h This event was generated to correspond to the Legacy Telemetry event security.ui.certerror.click#learn_more_link.
   */
  constexpr impl::EventMetric<ClickLearnMoreLinkExtra> click_learn_more_link(5875);

  /**
   * generated from security.ui.certerror.click_return_button_adv
   */
  struct ClickReturnButtonAdvExtra {
    mozilla::Maybe<bool> hasSts;
    mozilla::Maybe<bool> isFrame;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hasSts) {
        extraKeys.AppendElement()->AssignASCII("has_sts");
        extraValues.AppendElement()->AssignASCII(hasSts.value() ? "true" : "false");
      }
      if (isFrame) {
        extraKeys.AppendElement()->AssignASCII("is_frame");
        extraValues.AppendElement()->AssignASCII(isFrame.value() ? "true" : "false");
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click events on the cert error page. Keyed by error code, see https://searchfox.org/mozilla- central/source/security/nss/lib/mozpkix/include/pkix/Result.h This event was generated to correspond to the Legacy Telemetry event security.ui.certerror.click#return_button_adv.
   */
  constexpr impl::EventMetric<ClickReturnButtonAdvExtra> click_return_button_adv(5876);

  /**
   * generated from security.ui.certerror.click_return_button_top
   */
  struct ClickReturnButtonTopExtra {
    mozilla::Maybe<bool> hasSts;
    mozilla::Maybe<bool> isFrame;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (hasSts) {
        extraKeys.AppendElement()->AssignASCII("has_sts");
        extraValues.AppendElement()->AssignASCII(hasSts.value() ? "true" : "false");
      }
      if (isFrame) {
        extraKeys.AppendElement()->AssignASCII("is_frame");
        extraValues.AppendElement()->AssignASCII(isFrame.value() ? "true" : "false");
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * User interaction by click events on the cert error page. Keyed by error code, see https://searchfox.org/mozilla- central/source/security/nss/lib/mozpkix/include/pkix/Result.h This event was generated to correspond to the Legacy Telemetry event security.ui.certerror.click#return_button_top.
   */
  constexpr impl::EventMetric<ClickReturnButtonTopExtra> click_return_button_top(5877);

  /**
   * generated from security.ui.certerror.load_aboutcerterror
   */
  struct LoadAboutcerterrorExtra {
    mozilla::Maybe<uint32_t> channelStatus;
    mozilla::Maybe<bool> hasSts;
    mozilla::Maybe<bool> hyphenCompat;
    mozilla::Maybe<bool> isFrame;
    mozilla::Maybe<bool> issuedByCca;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (channelStatus) {
        extraKeys.AppendElement()->AssignASCII("channel_status");
        extraValues.AppendElement()->AppendInt(channelStatus.value());
      }
      if (hasSts) {
        extraKeys.AppendElement()->AssignASCII("has_sts");
        extraValues.AppendElement()->AssignASCII(hasSts.value() ? "true" : "false");
      }
      if (hyphenCompat) {
        extraKeys.AppendElement()->AssignASCII("hyphen_compat");
        extraValues.AppendElement()->AssignASCII(hyphenCompat.value() ? "true" : "false");
      }
      if (isFrame) {
        extraKeys.AppendElement()->AssignASCII("is_frame");
        extraValues.AppendElement()->AssignASCII(isFrame.value() ? "true" : "false");
      }
      if (issuedByCca) {
        extraKeys.AppendElement()->AssignASCII("issued_by_cca");
        extraValues.AppendElement()->AssignASCII(issuedByCca.value() ? "true" : "false");
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The about:certerror page is loaded, keyed by error code, see https://searchfox.org/mozilla- central/source/security/nss/lib/mozpkix/include/pkix/Result.h This event was generated to correspond to the Legacy Telemetry event security.ui.certerror.load#aboutcerterror.
   */
  constexpr impl::EventMetric<LoadAboutcerterrorExtra> load_aboutcerterror(5878);
}

namespace security_ui_tlserror {
  /**
   * generated from security.ui.tlserror.load_abouttlserror
   */
  struct LoadAbouttlserrorExtra {
    mozilla::Maybe<uint32_t> channelStatus;
    mozilla::Maybe<bool> isFrame;
    mozilla::Maybe<nsCString> value;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (channelStatus) {
        extraKeys.AppendElement()->AssignASCII("channel_status");
        extraValues.AppendElement()->AppendInt(channelStatus.value());
      }
      if (isFrame) {
        extraKeys.AppendElement()->AssignASCII("is_frame");
        extraValues.AppendElement()->AssignASCII(isFrame.value() ? "true" : "false");
      }
      if (value) {
        extraKeys.AppendElement()->AssignASCII("value");
        extraValues.EmplaceBack(value.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The about:neterror page is loaded with a TLS error or non- overridable certificate error, keyed by error code. This event was generated to correspond to the Legacy Telemetry event security.ui.tlserror.load#abouttlserror.
   */
  constexpr impl::EventMetric<LoadAbouttlserrorExtra> load_abouttlserror(5879);
}

} // namespace mozilla::glean

#endif // mozilla_GleanToolkitContentMetrics_h
