// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanTranslationsMetrics_h
#define mozilla_GleanTranslationsMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace translations {
  /**
   * generated from translations.engine_performance
   */
  struct EnginePerformanceExtra {
    mozilla::Maybe<uint32_t> averageWordsPerRequest;
    mozilla::Maybe<uint32_t> averageWordsPerSecond;
    mozilla::Maybe<nsCString> fromLanguage;
    mozilla::Maybe<nsCString> toLanguage;
    mozilla::Maybe<uint32_t> totalCompletedRequests;
    mozilla::Maybe<uint32_t> totalInferenceSeconds;
    mozilla::Maybe<uint32_t> totalTranslatedWords;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (averageWordsPerRequest) {
        extraKeys.AppendElement()->AssignASCII("average_words_per_request");
        extraValues.AppendElement()->AppendInt(averageWordsPerRequest.value());
      }
      if (averageWordsPerSecond) {
        extraKeys.AppendElement()->AssignASCII("average_words_per_second");
        extraValues.AppendElement()->AppendInt(averageWordsPerSecond.value());
      }
      if (fromLanguage) {
        extraKeys.AppendElement()->AssignASCII("from_language");
        extraValues.EmplaceBack(fromLanguage.value());
      }
      if (toLanguage) {
        extraKeys.AppendElement()->AssignASCII("to_language");
        extraValues.EmplaceBack(toLanguage.value());
      }
      if (totalCompletedRequests) {
        extraKeys.AppendElement()->AssignASCII("total_completed_requests");
        extraValues.AppendElement()->AppendInt(totalCompletedRequests.value());
      }
      if (totalInferenceSeconds) {
        extraKeys.AppendElement()->AssignASCII("total_inference_seconds");
        extraValues.AppendElement()->AppendInt(totalInferenceSeconds.value());
      }
      if (totalTranslatedWords) {
        extraKeys.AppendElement()->AssignASCII("total_translated_words");
        extraValues.AppendElement()->AppendInt(totalTranslatedWords.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Metrics related to the performance of the TranslationsEngine.
   */
  constexpr impl::EventMetric<EnginePerformanceExtra> engine_performance(5786);

  /**
   * generated from translations.error
   */
  struct ErrorExtra {
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> reason;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (reason) {
        extraKeys.AppendElement()->AssignASCII("reason");
        extraValues.EmplaceBack(reason.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * The specific translations error that caused a full_page translation failure.
   */
  constexpr impl::EventMetric<ErrorExtra> error(5787);

  /**
   * generated from translations.identify_page_language
   */
  struct IdentifyPageLanguageExtra {
    mozilla::Maybe<bool> confident;
    mozilla::Maybe<uint32_t> extractedCodeUnits;
    mozilla::Maybe<uint32_t> extractionTime;
    mozilla::Maybe<nsCString> htmlLangAttribute;
    mozilla::Maybe<uint32_t> identificationTime;
    mozilla::Maybe<nsCString> identifiedLanguage;
    mozilla::Maybe<bool> isLangAttributeValid;
    mozilla::Maybe<bool> langTagsMatch;
    mozilla::Maybe<uint32_t> totalTime;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (confident) {
        extraKeys.AppendElement()->AssignASCII("confident");
        extraValues.AppendElement()->AssignASCII(confident.value() ? "true" : "false");
      }
      if (extractedCodeUnits) {
        extraKeys.AppendElement()->AssignASCII("extracted_code_units");
        extraValues.AppendElement()->AppendInt(extractedCodeUnits.value());
      }
      if (extractionTime) {
        extraKeys.AppendElement()->AssignASCII("extraction_time");
        extraValues.AppendElement()->AppendInt(extractionTime.value());
      }
      if (htmlLangAttribute) {
        extraKeys.AppendElement()->AssignASCII("html_lang_attribute");
        extraValues.EmplaceBack(htmlLangAttribute.value());
      }
      if (identificationTime) {
        extraKeys.AppendElement()->AssignASCII("identification_time");
        extraValues.AppendElement()->AppendInt(identificationTime.value());
      }
      if (identifiedLanguage) {
        extraKeys.AppendElement()->AssignASCII("identified_language");
        extraValues.EmplaceBack(identifiedLanguage.value());
      }
      if (isLangAttributeValid) {
        extraKeys.AppendElement()->AssignASCII("is_lang_attribute_valid");
        extraValues.AppendElement()->AssignASCII(isLangAttributeValid.value() ? "true" : "false");
      }
      if (langTagsMatch) {
        extraKeys.AppendElement()->AssignASCII("lang_tags_match");
        extraValues.AppendElement()->AssignASCII(langTagsMatch.value() ? "true" : "false");
      }
      if (totalTime) {
        extraKeys.AppendElement()->AssignASCII("total_time");
        extraValues.AppendElement()->AppendInt(totalTime.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the language of a page is identified for Translations.
   */
  constexpr impl::EventMetric<IdentifyPageLanguageExtra> identify_page_language(5788);

  /**
   * generated from translations.request_count
   */
  enum class RequestCountLabel: uint16_t {
    eFullPage = 0,
    eSelect = 1,
    e__Other__,
  };
  /**
   * The count of translation requests, along with their type.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, RequestCountLabel> request_count(5789);

  /**
   * generated from translations.restore_page
   */
  struct RestorePageExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the a restore-page event is triggered.
   */
  constexpr impl::EventMetric<RestorePageExtra> restore_page(5790);

  /**
   * generated from translations.translation_request
   */
  struct TranslationRequestExtra {
    mozilla::Maybe<bool> autoTranslate;
    mozilla::Maybe<nsCString> documentLanguage;
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> fromLanguage;
    mozilla::Maybe<nsCString> requestTarget;
    mozilla::Maybe<uint32_t> sourceTextCodeUnits;
    mozilla::Maybe<uint32_t> sourceTextWordCount;
    mozilla::Maybe<nsCString> toLanguage;
    mozilla::Maybe<nsCString> topPreferredLanguage;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (autoTranslate) {
        extraKeys.AppendElement()->AssignASCII("auto_translate");
        extraValues.AppendElement()->AssignASCII(autoTranslate.value() ? "true" : "false");
      }
      if (documentLanguage) {
        extraKeys.AppendElement()->AssignASCII("document_language");
        extraValues.EmplaceBack(documentLanguage.value());
      }
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (fromLanguage) {
        extraKeys.AppendElement()->AssignASCII("from_language");
        extraValues.EmplaceBack(fromLanguage.value());
      }
      if (requestTarget) {
        extraKeys.AppendElement()->AssignASCII("request_target");
        extraValues.EmplaceBack(requestTarget.value());
      }
      if (sourceTextCodeUnits) {
        extraKeys.AppendElement()->AssignASCII("source_text_code_units");
        extraValues.AppendElement()->AppendInt(sourceTextCodeUnits.value());
      }
      if (sourceTextWordCount) {
        extraKeys.AppendElement()->AssignASCII("source_text_word_count");
        extraValues.AppendElement()->AppendInt(sourceTextWordCount.value());
      }
      if (toLanguage) {
        extraKeys.AppendElement()->AssignASCII("to_language");
        extraValues.EmplaceBack(toLanguage.value());
      }
      if (topPreferredLanguage) {
        extraKeys.AppendElement()->AssignASCII("top_preferred_language");
        extraValues.EmplaceBack(topPreferredLanguage.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when a full-page translation request is sent.
   */
  constexpr impl::EventMetric<TranslationRequestExtra> translation_request(5791);
}

namespace translations_about_translations_page {
  /**
   * generated from translations.about_translations_page.open
   */
  struct OpenExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the about-translations page is opened.
   */
  constexpr impl::EventMetric<OpenExtra> open(5792);
}

namespace translations_panel {
  /**
   * generated from translations.panel.about_translations
   */
  struct AboutTranslationsExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the about-translations menuitem is invoked in the full-page translations panel settings.
   */
  constexpr impl::EventMetric<AboutTranslationsExtra> about_translations(5793);

  /**
   * generated from translations.panel.always_offer_translations
   */
  struct AlwaysOfferTranslationsExtra {
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<bool> toggledOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (toggledOn) {
        extraKeys.AppendElement()->AssignASCII("toggled_on");
        extraValues.AppendElement()->AssignASCII(toggledOn.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the always-offer-translations menuitem is invoked in the full-page translations panel seeings.
   */
  constexpr impl::EventMetric<AlwaysOfferTranslationsExtra> always_offer_translations(5794);

  /**
   * generated from translations.panel.always_translate_language
   */
  struct AlwaysTranslateLanguageExtra {
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> language;
    mozilla::Maybe<bool> toggledOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (language) {
        extraKeys.AppendElement()->AssignASCII("language");
        extraValues.EmplaceBack(language.value());
      }
      if (toggledOn) {
        extraKeys.AppendElement()->AssignASCII("toggled_on");
        extraValues.AppendElement()->AssignASCII(toggledOn.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the always-translate-language menuitem is invoked in the full-page translations panel settings.
   */
  constexpr impl::EventMetric<AlwaysTranslateLanguageExtra> always_translate_language(5795);

  /**
   * generated from translations.panel.cancel_button
   */
  struct CancelButtonExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the cancel button is invoked in the full-page translations panel.
   */
  constexpr impl::EventMetric<CancelButtonExtra> cancel_button(5796);

  /**
   * generated from translations.panel.change_from_language
   */
  struct ChangeFromLanguageExtra {
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> language;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (language) {
        extraKeys.AppendElement()->AssignASCII("language");
        extraValues.EmplaceBack(language.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the from-language selected value is changed.
   */
  constexpr impl::EventMetric<ChangeFromLanguageExtra> change_from_language(5797);

  /**
   * generated from translations.panel.change_source_language_button
   */
  struct ChangeSourceLanguageButtonExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the change-source-language button is invoked in the full-page translations panel.
   */
  constexpr impl::EventMetric<ChangeSourceLanguageButtonExtra> change_source_language_button(5798);

  /**
   * generated from translations.panel.change_to_language
   */
  struct ChangeToLanguageExtra {
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> language;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (language) {
        extraKeys.AppendElement()->AssignASCII("language");
        extraValues.EmplaceBack(language.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the to-language selected value is changed.
   */
  constexpr impl::EventMetric<ChangeToLanguageExtra> change_to_language(5799);

  /**
   * generated from translations.panel.close
   */
  struct CloseExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when full-page translations panel is closed.
   */
  constexpr impl::EventMetric<CloseExtra> close(5800);

  /**
   * generated from translations.panel.close_from_language_menu
   */
  struct CloseFromLanguageMenuExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the from-language dropdown is closed in the full-page translations panel.
   */
  constexpr impl::EventMetric<CloseFromLanguageMenuExtra> close_from_language_menu(5801);

  /**
   * generated from translations.panel.close_settings_menu
   */
  struct CloseSettingsMenuExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the settings menu is closed in the full-page translations panel.
   */
  constexpr impl::EventMetric<CloseSettingsMenuExtra> close_settings_menu(5802);

  /**
   * generated from translations.panel.close_to_language_menu
   */
  struct CloseToLanguageMenuExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the from-language dropdown is closed in the full-page translations panel.
   */
  constexpr impl::EventMetric<CloseToLanguageMenuExtra> close_to_language_menu(5803);

  /**
   * generated from translations.panel.dismiss_error_button
   */
  struct DismissErrorButtonExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the dismiss-error button is invoked in the full-page translations panel.
   */
  constexpr impl::EventMetric<DismissErrorButtonExtra> dismiss_error_button(5804);

  /**
   * generated from translations.panel.learn_more
   */
  struct LearnMoreExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the learn-more link is invoked in the full-page translations panel first interaction.
   */
  constexpr impl::EventMetric<LearnMoreExtra> learn_more(5805);

  /**
   * generated from translations.panel.manage_languages
   */
  struct ManageLanguagesExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the manage-languages menuitem is invoked in the full-page translations panel settings.
   */
  constexpr impl::EventMetric<ManageLanguagesExtra> manage_languages(5806);

  /**
   * generated from translations.panel.never_translate_language
   */
  struct NeverTranslateLanguageExtra {
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> language;
    mozilla::Maybe<bool> toggledOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (language) {
        extraKeys.AppendElement()->AssignASCII("language");
        extraValues.EmplaceBack(language.value());
      }
      if (toggledOn) {
        extraKeys.AppendElement()->AssignASCII("toggled_on");
        extraValues.AppendElement()->AssignASCII(toggledOn.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the never-translate-language menuitem is invoked in the full-page translations panel settings.
   */
  constexpr impl::EventMetric<NeverTranslateLanguageExtra> never_translate_language(5807);

  /**
   * generated from translations.panel.never_translate_site
   */
  struct NeverTranslateSiteExtra {
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<bool> toggledOn;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (toggledOn) {
        extraKeys.AppendElement()->AssignASCII("toggled_on");
        extraValues.AppendElement()->AssignASCII(toggledOn.value() ? "true" : "false");
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the never-translate-site menuitem is invoked in the full-page translations panel settings.
   */
  constexpr impl::EventMetric<NeverTranslateSiteExtra> never_translate_site(5808);

  /**
   * generated from translations.panel.open
   */
  struct OpenExtra {
    mozilla::Maybe<bool> autoShow;
    mozilla::Maybe<nsCString> documentLanguage;
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> openedFrom;
    mozilla::Maybe<nsCString> viewName;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (autoShow) {
        extraKeys.AppendElement()->AssignASCII("auto_show");
        extraValues.AppendElement()->AssignASCII(autoShow.value() ? "true" : "false");
      }
      if (documentLanguage) {
        extraKeys.AppendElement()->AssignASCII("document_language");
        extraValues.EmplaceBack(documentLanguage.value());
      }
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (openedFrom) {
        extraKeys.AppendElement()->AssignASCII("opened_from");
        extraValues.EmplaceBack(openedFrom.value());
      }
      if (viewName) {
        extraKeys.AppendElement()->AssignASCII("view_name");
        extraValues.EmplaceBack(viewName.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the full-page translations panel is opened.
   */
  constexpr impl::EventMetric<OpenExtra> open(5809);

  /**
   * generated from translations.panel.open_from_language_menu
   */
  struct OpenFromLanguageMenuExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the from-language dropdown is opened in the full-page translations panel.
   */
  constexpr impl::EventMetric<OpenFromLanguageMenuExtra> open_from_language_menu(5810);

  /**
   * generated from translations.panel.open_settings_menu
   */
  struct OpenSettingsMenuExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the settings menu is opened in the full-page translations panel.
   */
  constexpr impl::EventMetric<OpenSettingsMenuExtra> open_settings_menu(5811);

  /**
   * generated from translations.panel.open_to_language_menu
   */
  struct OpenToLanguageMenuExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the from-language dropdown is opened in the full-page translations panel.
   */
  constexpr impl::EventMetric<OpenToLanguageMenuExtra> open_to_language_menu(5812);

  /**
   * generated from translations.panel.restore_page_button
   */
  struct RestorePageButtonExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the restore-page button is invoked in the full-page translations panel.
   */
  constexpr impl::EventMetric<RestorePageButtonExtra> restore_page_button(5813);

  /**
   * generated from translations.panel.translate_button
   */
  struct TranslateButtonExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the translate button is invoked in the full-page translations panel.
   */
  constexpr impl::EventMetric<TranslateButtonExtra> translate_button(5814);
}

namespace translations_select_translations_panel {
  /**
   * generated from translations.select_translations_panel.about_translations
   */
  struct AboutTranslationsExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the about-translations menuitem is invoked in the select translations panel settings.
   */
  constexpr impl::EventMetric<AboutTranslationsExtra> about_translations(5815);

  /**
   * generated from translations.select_translations_panel.cancel_button
   */
  struct CancelButtonExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the cancel button is invoked in the select translations panel.
   */
  constexpr impl::EventMetric<CancelButtonExtra> cancel_button(5816);

  /**
   * generated from translations.select_translations_panel.change_from_language
   */
  struct ChangeFromLanguageExtra {
    mozilla::Maybe<nsCString> documentLanguage;
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> language;
    mozilla::Maybe<nsCString> previousLanguage;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (documentLanguage) {
        extraKeys.AppendElement()->AssignASCII("document_language");
        extraValues.EmplaceBack(documentLanguage.value());
      }
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (language) {
        extraKeys.AppendElement()->AssignASCII("language");
        extraValues.EmplaceBack(language.value());
      }
      if (previousLanguage) {
        extraKeys.AppendElement()->AssignASCII("previous_language");
        extraValues.EmplaceBack(previousLanguage.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the from-language selected value is changed.
   */
  constexpr impl::EventMetric<ChangeFromLanguageExtra> change_from_language(5817);

  /**
   * generated from translations.select_translations_panel.change_to_language
   */
  struct ChangeToLanguageExtra {
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> language;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (language) {
        extraKeys.AppendElement()->AssignASCII("language");
        extraValues.EmplaceBack(language.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the to-language selected value is changed.
   */
  constexpr impl::EventMetric<ChangeToLanguageExtra> change_to_language(5818);

  /**
   * generated from translations.select_translations_panel.close
   */
  struct CloseExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the select translations panel is closed.
   */
  constexpr impl::EventMetric<CloseExtra> close(5819);

  /**
   * generated from translations.select_translations_panel.copy_button
   */
  struct CopyButtonExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the copy button is invoked in the select translations panel.
   */
  constexpr impl::EventMetric<CopyButtonExtra> copy_button(5820);

  /**
   * generated from translations.select_translations_panel.done_button
   */
  struct DoneButtonExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the done button is invoked in the select translations panel.
   */
  constexpr impl::EventMetric<DoneButtonExtra> done_button(5821);

  /**
   * generated from translations.select_translations_panel.initialization_failure_message
   */
  struct InitializationFailureMessageExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the initialization-failure message is shown in the select translations panel.
   */
  constexpr impl::EventMetric<InitializationFailureMessageExtra> initialization_failure_message(5822);

  /**
   * generated from translations.select_translations_panel.open
   */
  struct OpenExtra {
    mozilla::Maybe<nsCString> documentLanguage;
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> fromLanguage;
    mozilla::Maybe<nsCString> textSource;
    mozilla::Maybe<nsCString> toLanguage;
    mozilla::Maybe<nsCString> topPreferredLanguage;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (documentLanguage) {
        extraKeys.AppendElement()->AssignASCII("document_language");
        extraValues.EmplaceBack(documentLanguage.value());
      }
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (fromLanguage) {
        extraKeys.AppendElement()->AssignASCII("from_language");
        extraValues.EmplaceBack(fromLanguage.value());
      }
      if (textSource) {
        extraKeys.AppendElement()->AssignASCII("text_source");
        extraValues.EmplaceBack(textSource.value());
      }
      if (toLanguage) {
        extraKeys.AppendElement()->AssignASCII("to_language");
        extraValues.EmplaceBack(toLanguage.value());
      }
      if (topPreferredLanguage) {
        extraKeys.AppendElement()->AssignASCII("top_preferred_language");
        extraValues.EmplaceBack(topPreferredLanguage.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the select translations panel is opened.
   */
  constexpr impl::EventMetric<OpenExtra> open(5823);

  /**
   * generated from translations.select_translations_panel.open_settings_menu
   */
  struct OpenSettingsMenuExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the settings menu is opened in the select translations panel.
   */
  constexpr impl::EventMetric<OpenSettingsMenuExtra> open_settings_menu(5824);

  /**
   * generated from translations.select_translations_panel.translate_button
   */
  struct TranslateButtonExtra {
    mozilla::Maybe<nsCString> detectedLanguage;
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> fromLanguage;
    mozilla::Maybe<nsCString> toLanguage;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (detectedLanguage) {
        extraKeys.AppendElement()->AssignASCII("detected_language");
        extraValues.EmplaceBack(detectedLanguage.value());
      }
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (fromLanguage) {
        extraKeys.AppendElement()->AssignASCII("from_language");
        extraValues.EmplaceBack(fromLanguage.value());
      }
      if (toLanguage) {
        extraKeys.AppendElement()->AssignASCII("to_language");
        extraValues.EmplaceBack(toLanguage.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the translate button is invoked in the select translations panel.
   */
  constexpr impl::EventMetric<TranslateButtonExtra> translate_button(5825);

  /**
   * generated from translations.select_translations_panel.translate_full_page_button
   */
  struct TranslateFullPageButtonExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the translate-full-page button is invoked in the select translations panel.
   */
  constexpr impl::EventMetric<TranslateFullPageButtonExtra> translate_full_page_button(5826);

  /**
   * generated from translations.select_translations_panel.translation_failure_message
   */
  struct TranslationFailureMessageExtra {
    mozilla::Maybe<nsCString> flowId;
    mozilla::Maybe<nsCString> fromLanguage;
    mozilla::Maybe<nsCString> toLanguage;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      if (fromLanguage) {
        extraKeys.AppendElement()->AssignASCII("from_language");
        extraValues.EmplaceBack(fromLanguage.value());
      }
      if (toLanguage) {
        extraKeys.AppendElement()->AssignASCII("to_language");
        extraValues.EmplaceBack(toLanguage.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the translation-failure message is shown in the select translations panel.
   */
  constexpr impl::EventMetric<TranslationFailureMessageExtra> translation_failure_message(5827);

  /**
   * generated from translations.select_translations_panel.translation_settings
   */
  struct TranslationSettingsExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the translation-settings menuitem is invoked in the select translations panel settings.
   */
  constexpr impl::EventMetric<TranslationSettingsExtra> translation_settings(5828);

  /**
   * generated from translations.select_translations_panel.try_again_button
   */
  struct TryAgainButtonExtra {
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the try-again button is invoked in the select translations panel.
   */
  constexpr impl::EventMetric<TryAgainButtonExtra> try_again_button(5829);

  /**
   * generated from translations.select_translations_panel.unsupported_language_message
   */
  struct UnsupportedLanguageMessageExtra {
    mozilla::Maybe<nsCString> detectedLanguage;
    mozilla::Maybe<nsCString> documentLanguage;
    mozilla::Maybe<nsCString> flowId;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (detectedLanguage) {
        extraKeys.AppendElement()->AssignASCII("detected_language");
        extraValues.EmplaceBack(detectedLanguage.value());
      }
      if (documentLanguage) {
        extraKeys.AppendElement()->AssignASCII("document_language");
        extraValues.EmplaceBack(documentLanguage.value());
      }
      if (flowId) {
        extraKeys.AppendElement()->AssignASCII("flow_id");
        extraValues.EmplaceBack(flowId.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Triggers when the unsupported-language message is shown in the select translations panel.
   */
  constexpr impl::EventMetric<UnsupportedLanguageMessageExtra> unsupported_language_message(5830);
}

} // namespace mozilla::glean

#endif // mozilla_GleanTranslationsMetrics_h
