# Contributing to Mozilla Mobile's Android projects

Thank you for taking the time to contribute to one of Mozilla's Android
projects! 🔥 🦊 <3 🤖! 🎉 👍 For a full list of projects, see
[the README](../../../README.md).

Before contributing, please review our [Community Participation Guidelines].

We welcome all types of contributions, including, but not limited to:
* [Filing issues](#filing-issues)
* [Translating our apps](#translating-our-apps)
* [User experience design](#user-experience-design)
* [Writing documentation](#writing-documentation)
* [Testing the app](#testing-the-app)
* [Writing code](./CONTRIBUTING_code.md)

Have another idea for how you can contribute? Let us know!

## Communication
For each our projects, we communicate with the project's:
- Issues tracker
- Mailing list
- [Matrix Fenix](https://chat.mozilla.org/#/room/#fenix:mozilla.org) channel. *We're available Monday-Friday
during GMT and PST working hours.*

**Be sure to join them** and don't be afraid to make postings of your
own! A link to each project-specific communication channel can be found in
the project's README.

## Filing issues

We usually track our project's issues on GitHub (example: [focus-android][fa issues]).
To file a bug:
* Find your project's issues: these will be linked from the project's README
or you can click directly into the issues from the project's home page
* Create a new issue!

To ensure we can understand, reproduce, and effectively triage your issues,
**please fill out the provided template** when filing an issue! When issues
are filed in a consistent style and include the information we need to
make decisions, we're more likely to take action on these issues than if
we don't understand them.

*Be sure to include any extra information you find valuable!* For example, posting
[your user agent](https://duckduckgo.com/?q=my+user+agent) can help us debug problems.

## Translating our apps

* Get in touch with the [existing localization
  team](https://wiki.mozilla.org/L10n:Teams).
* Localization happens on
  [Pontoon](https://pontoon.mozilla.org/projects/) (example: [focus-android][fa pontoon]).

## User experience design

Get in touch with one of our designers (@brampitoyo or @aminalhazwani)
or other core team members to get involved! With a limited number of engineers, we
can't implement every design so we want to make sure any design work you do will
make it into our products.

## Writing documentation

### Product support documentation
Each Mozilla product provides in-app support. This documentation can be found on
[support.mozilla.org][sumo]. If you wish to contribute, please contact a core team
member to get started.

### Developer/repository documentation
See an issue with our documentation, either in a project's repository or this
`shared-docs` repository? Please file an issue or create a pull request
to fix it yourself!

## Testing the app

* Download one of our products and look for issues. Some products have pre-release
Beta builds: check out their READMEs to download them!
* File [new issues](#filing-issues) for all bugs you encounter. Make sure that an
issue isn't filed already (via the search).
* Make sure that your bug report follows the provided template
* Try to reproduce issues reported by others and add additional or missing
information to the bug reports.

## Writing code

See [CONTRIBUTING_code.md](./CONTRIBUTING_code.md).

[Community Participation Guidelines]: https://www.mozilla.org/en-US/about/governance/policies/participation/
[fa issues]: https://github.com/mozilla-mobile/focus-android/issues
[fa pontoon]: https://pontoon.mozilla.org/projects/focus-for-android/
[sumo]: https://support.mozilla.org/en-US/
