/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

package org.mozilla.fenix.debugsettings

import org.junit.Assert.assertEquals
import org.junit.Test
import org.mozilla.fenix.debugsettings.store.DebugDrawerAction
import org.mozilla.fenix.debugsettings.store.DebugDrawerState
import org.mozilla.fenix.debugsettings.store.DebugDrawerStore
import org.mozilla.fenix.debugsettings.store.DrawerStatus

class DebugDrawerStoreTest {

    @Test
    fun `GIVEN the drawer is closed WHEN the drawer is opened THEN the state should be set to open`() {
        val expected = DrawerStatus.Open
        val store = createStore()

        store.dispatch(DebugDrawerAction.DrawerOpened)

        assertEquals(expected, store.state.drawerStatus)
    }

    @Test
    fun `GIVEN the drawer is opened WHEN the drawer is closed THEN the state should be set to closed`() {
        val expected = DrawerStatus.Closed
        val store = createStore(
            drawerStatus = DrawerStatus.Open,
        )

        store.dispatch(DebugDrawerAction.DrawerClosed)

        assertEquals(expected, store.state.drawerStatus)
    }

    private fun createStore(
        drawerStatus: DrawerStatus = DrawerStatus.Closed,
    ) = DebugDrawerStore(
        initialState = DebugDrawerState(
            drawerStatus = drawerStatus,
        ),
    )
}
