/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

package org.mozilla.fenix.search

import io.mockk.mockk
import kotlinx.coroutines.ExperimentalCoroutinesApi
import kotlinx.coroutines.test.UnconfinedTestDispatcher
import kotlinx.coroutines.test.runTest
import mozilla.components.browser.state.action.SearchAction.ApplicationSearchEnginesLoaded
import mozilla.components.browser.state.search.SearchEngine
import mozilla.components.browser.state.state.BrowserState
import mozilla.components.browser.state.state.SearchState
import mozilla.components.browser.state.store.BrowserStore
import org.junit.Assert.assertEquals
import org.junit.Test
import org.junit.runner.RunWith
import org.mozilla.fenix.search.fixtures.EMPTY_SEARCH_FRAGMENT_STATE
import org.robolectric.RobolectricTestRunner

@RunWith(RobolectricTestRunner::class)
class BrowserStoreToFenixSearchMapperMiddlewareTest {
    @OptIn(ExperimentalCoroutinesApi::class)
    @Test
    fun `WHEN the browser search state changes THEN update the application search state`() = runTest(UnconfinedTestDispatcher()) {
        val defaultSearchEngine: SearchEngine = mockk()
        val newSearchEngines: List<SearchEngine> = listOf(defaultSearchEngine, mockk())
        val browserStore = BrowserStore(
            BrowserState(
                search = SearchState(
                    applicationSearchEngines = newSearchEngines,
                ),
            ),
        )
        val middleware = BrowserStoreToFenixSearchMapperMiddleware(browserStore, backgroundScope)
        val searchStore = buildStore(middleware)

        browserStore.dispatch(ApplicationSearchEnginesLoaded(newSearchEngines))

        assertEquals(defaultSearchEngine, searchStore.state.defaultEngine)
    }

    private fun buildStore(middleware: BrowserStoreToFenixSearchMapperMiddleware) = SearchFragmentStore(
        initialState = EMPTY_SEARCH_FRAGMENT_STATE,
        middleware = listOf(middleware),
    )
}
